//Source file: F:\jschwartz\src\Alkindi\BusinessDataTypes\ProductClusterList.java

/* Copyright (C) 2000 Alikindi, LLC */

package Alkindi.BusinessDataTypes;

import java.io.Serializable;
import java.util.Vector;
import java.util.Iterator;

/**
 * A list of product clusters. * @author 
 */
public class ProductClusterList implements Serializable 
{
	private Vector internalList;
	
	public ProductClusterList() 
	{
		internalList = new Vector();
	}
	
	/**
	 * @param itemToAdd
	 * @return boolean
	 * @exception 
	 * @roseuid 39D3693601C5
	 */
	public boolean add(ProductCluster itemToAdd) 
	{
		return internalList.add(itemToAdd);
	}
	
	/**
	 * @return int
	 * @exception 
	 * @roseuid 39D36935004E
	 */
	public int capacity() 
	{
		return internalList.capacity();
	}
	
	/**
	 * @param idx
	 * @return ProductCluster
	 * @exception 
	 * @roseuid 39D369330203
	 */
	public ProductCluster get(int idx) 
	{
		return (ProductCluster) internalList.get(idx);
	}
	
	/**
	 * @return Iterator
	 * @exception 
	 * @roseuid 39D3693103D8
	 */
	public Iterator iterator() 
	{
		return internalList.iterator();
	}
	
	/**
	 * @param numInit
	 * @exception 
	 * @roseuid 39D36937036B
	 */
	public ProductClusterList(int numInit) 
	{
		internalList = new Vector(numInit);
	}
	
	/**
	 * @return int
	 * @exception 
	 * @roseuid 39D369300213
	 */
	public int size() 
	{
		return internalList.size();
	}
}
